import Flutter
import UIKit
import WebKit
import WKWebViewJavascriptBridge
public class SwiftFlutterBridgeWebviewPlugin: NSObject, FlutterPlugin {
    var webview:WKWebView?
    var viewController:UIViewController?
    var bridge:WKWebViewJavascriptBridge!
    private var initUrl:String?
    static var methodChannel:FlutterMethodChannel!
    public static func register(with registrar: FlutterPluginRegistrar) {
        methodChannel = FlutterMethodChannel(name: "com.microduino.flutter/bridgewebview", binaryMessenger: registrar.messenger())
        let instance = SwiftFlutterBridgeWebviewPlugin()
        if let viewController = UIApplication.shared.delegate!.window!!.rootViewController{
            instance.initWithViewControler(viewController)
        }
        registrar.addMethodCallDelegate(instance, channel: methodChannel)
        
    }
    
    func initWithViewControler(_ viewController:UIViewController){
        if(self.viewController == nil){
            self.viewController = viewController
        }
    }
    
    public func handle(_ call: FlutterMethodCall, result: @escaping FlutterResult) {
        print("handle",call.method)
        switch call.method {
        case "launch":
            if(self.webview == nil){
                self.initWebView(call,result: result)
            }else{
                self.navigate(call,result: result)
            }
        case "callHandler":
            self.callHandler(call,result: result)
        case "show":
            self.show(result)
        case "hide":
            self.hide(result)
        case "close":
            self.close(call,result: result)
        default:break
        }
    }
    
    func initWebView(_ call:FlutterMethodCall,result:@escaping FlutterResult){
        let hidden = (call.arguments as! Dictionary<String,Any>)["hidden"] as! Bool
        let bridgeChannelNames = (call.arguments as! Dictionary<String,Any>)["bridgeChannels"] as! NSArray
        if let viewController = self.viewController{
            let config = WKWebViewConfiguration()
            config.selectionGranularity = .character
            self.webview = WKWebView(frame:UIScreen.main.bounds,configuration: config)
            self.webview?.backgroundColor = .red
            self.webview?.uiDelegate = self
            self.webview?.navigationDelegate = self
            self.webview?.scrollView.isScrollEnabled = false
            self.webview?.isHidden = hidden
            bridge = WKWebViewJavascriptBridge(webView:self.webview!)
            bridgeChannelNames.forEach{registerBridgeChannelNames($0 as! String)}
            viewController.view.addSubview(self.webview!)
            self.navigate(call,result:result)
        }
    }
    
    func navigate(_ call:FlutterMethodCall,result:FlutterResult){
            let url =  (call.arguments as! Dictionary<String,Any>)["url"] as! String
            initUrl = url
            do {
                let path = Bundle.main.bundlePath + url
                let content = try String(contentsOf: URL.init(fileURLWithPath:path + "index.html"), encoding: String.Encoding.utf8)
                self.webview!.loadHTMLString(content, baseURL:URL.init(fileURLWithPath:path))
            }
            catch _{

            }
            result(nil)
        
    }
    
    func callHandler(_ call:FlutterMethodCall,result:FlutterResult){
        let arguments = call.arguments as! Dictionary<String,Any>
        let name = arguments["name"] as! String
        let data = arguments["data"]
        self.bridge.call(handlerName:name, data:data!) { (callback) in
            SwiftFlutterBridgeWebviewPlugin.methodChannel.invokeMethod("onCallHandlerCallBack", arguments:["method":name])
        }
        result(nil)
        
    }
    
    func registerBridgeChannelNames(_ channelName:String){
        bridge.register(handlerName:channelName) { (paramters, callback) in
            let paramter = paramters != nil ? paramters!["name"] : paramters
                let data = ["method":channelName,"data":paramter as Any] as [String : Any]?
                SwiftFlutterBridgeWebviewPlugin.methodChannel.invokeMethod("onRegisterHandlerCallback", arguments: data, result: { (result) in
                    callback?(result)
                })
        }
    }
    
    func close(_ call:FlutterMethodCall,result:FlutterResult){
        if let viewController = UIApplication.shared.delegate!.window!!.rootViewController{
            if(viewController.view.subviews.contains(self.webview!)){
                self.webview?.removeFromSuperview()
            }
            webview = nil
            result(nil)
            SwiftFlutterBridgeWebviewPlugin.methodChannel.invokeMethod("onDestroy", arguments: nil)
        }
    }
    
    func show(_ result:FlutterResult){
        if(self.webview != nil){
            self.webview?.backgroundColor = .red
            self.webview?.isHidden = false
        }
    }
    
    func hide(_ result:FlutterResult){
        if(self.webview != nil){
            self.webview?.isHidden = true
        }
    }
}

extension SwiftFlutterBridgeWebviewPlugin:WKNavigationDelegate,WKUIDelegate,UIScrollViewDelegate{
 
    public func webView(_ webView: WKWebView, didReceive challenge: URLAuthenticationChallenge, completionHandler: @escaping (URLSession.AuthChallengeDisposition, URLCredential?) -> Void) {
        // 判断是否是信任服务器证书
        if challenge.protectionSpace.authenticationMethod
            == NSURLAuthenticationMethodServerTrust {
            // 告诉服务器，客户端信任证书
            // 创建凭据对象
            let card = URLCredential.init(trust: challenge.protectionSpace.serverTrust!)
            // 告诉服务器信任证书
            completionHandler(URLSession.AuthChallengeDisposition.useCredential, card)
        }
    }
    
    public func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 2) {
            if let url = self.initUrl {
                let data = ["url":url] as [String : Any]?
                SwiftFlutterBridgeWebviewPlugin.methodChannel.invokeMethod("onPageFinished", arguments: data)
            }
        }
    }

}
